function y = calc_SII(ene, peak_pos, Gamma, g0_mech_cav, par)

    function y = chi_opt(w)
        y = 1/(par.opt.K/2 - 1i*(w + par.opt.det));
    end

ene = ene*2*pi;

% sus_p_diag = zeros(1,size(ene,2));
% sus_m_diag = zeros(1,size(ene,2));
y = zeros(1,size(ene,2));

for k=1:size(ene, 2)
    sus_p_omeg = get_sus_matrix(ene(k), Gamma, peak_pos, ...
        g0_mech_cav, par);
    sus_m_omeg = get_sus_matrix(-ene(k), Gamma, peak_pos, ...
        g0_mech_cav, par);
    
%     transpose(g0_mech_cav).*temp(1:2:end,:)
    g0_vec = repelem(g0_mech_cav,2);

    sus_p_diag = g0_vec*sus_p_omeg;
    A_p = sus_p_diag(1:2:end);
    B_p = sus_p_diag(2:2:end);
    
    sus_m_diag = g0_vec*sus_m_omeg;
    A_m = sus_m_diag(1:2:end);
    B_m = sus_m_diag(2:2:end);
    
    % Only resonant terms
%     y(k) = par.mech.nb*par.opt.a_in^2*par.opt.Ke^2/4/...
%         (par.opt.det^2 + par.opt.K^2/4)*...
%         (conj(chi_opt(-ene(k)))*chi_opt(-ene(k))*...
%         sum(conj(A_m).*A_m + conj(B_m).*B_m) + ...
%         chi_opt(ene(k))*conj(chi_opt(ene(k)))*...
%         sum(A_p.*conj(A_p) + B_p.*conj(B_p)));

    % Resonant term for blue detuning (Correction phase)
%     y(k) = par.mech.nb*par.opt.a_in^2*par.opt.Ke^2/4/...
%         (par.opt.det^2 + par.opt.K^2/4)*...
%         (conj(chi_opt(-ene(k)))*chi_opt(-ene(k))*...
%         sum(conj(A_m).*A_m + conj(B_m).*B_m));
    
    % Resonant term for red detuning (Correction phase)
%     y(k) = par.mech.nb*par.opt.a_in^2*par.opt.Ke^2/4/...
%         (par.opt.det^2 + par.opt.K^2/4)*...
%         (chi_opt(ene(k))*conj(chi_opt(ene(k)))*...
%         sum(A_p.*conj(A_p) + B_p.*conj(B_p)));
    
    % All the terms
    y(k) = par.mech.nb*par.opt.a_in^2*par.opt.Ke^2/4/...
        (par.opt.det^2 + par.opt.K^2/4)*...
        (conj(chi_opt(-ene(k)))*chi_opt(-ene(k))*...
        sum(conj(A_m).*A_m + conj(B_m).*B_m) + ...
        ...
        chi_opt(ene(k))*conj(chi_opt(ene(k)))*...
        sum(A_p.*conj(A_p) + B_p.*conj(B_p))) - ...
        ...
        par.mech.nb*par.opt.a_in^2*par.opt.Ke^2/4*...
        (1/(1i*par.opt.det - par.opt.K/2)^2*...
        (chi_opt(ene(k))*chi_opt(-ene(k))*...
        sum(A_p.*B_m + B_p.*A_m)) + ...
        ...
        (1/(1i*par.opt.det + par.opt.K/2)^2*...
        (conj(chi_opt(-ene(k)))*conj(chi_opt(ene(k)))*...
        sum(conj(A_m).*conj(B_p) + conj(B_m).*conj(A_p)))));
    
end

end